/*******************************************************
Filename		:  	DW_process_data_request.sql
Release 		:  	STORET c2.0.5
SIR			:  	1633
Description		:  	Processes the batch data request by reading recorded information from dw_data_requests table for a given request_id.
Author		:	Ganesh Thadkamalla
Date			: 	August 11, 2005
       09/14/2005 - Added query_text2. -GT
Comments		:  	
**********************************************************/
create or replace procedure dw_process_data_request(p_req_id in number)
as

  lr_data_req dw_data_requests%rowtype;
  TYPE sds_cur IS REF CURSOR;
  sdsdata sds_cur;
  my_out_file		UTL_FILE.FILE_TYPE;
  out_file_name		VARCHAR2(30);
  iodir         		VARCHAR2(100);
  download_path 		VARCHAR2(100);
  sdrec varchar2(32000);
  lv_isn  number;
  v_zip_rc                number := 0;
  v_file_name             varchar2(200);
  v_exists 		      boolean;
  v_file_length 		number;
  v_blocksize 		number;
  v_time_start		number;
  v_time_current		number;
  lv_filesize_kb  number;
  lv_email_body varchar2(4000);
  lv_request_type varchar2(30);

begin
select * into lr_data_req from dw_data_requests
where request_id = p_req_id;

-- Process the request.
OPEN sdsdata FOR lr_data_req.QUERY_TEXT||lr_data_req.query_text2;

  iodir := DW_GLOB_VAR.LV_IODIR;
  my_out_file := UTL_FILE.FOPEN(iodir,lr_data_req.filename,'W',30000);         
  --
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.record_title);

IF lr_data_req.request_type = 'SDS' THEN
  LOOP
    FETCH sdsdata INTO lv_isn,sdrec;
    EXIT WHEN sdsdata%NOTFOUND;
    UTL_FILE.PUT_LINE(my_out_file,sdrec);
  END LOOP;
ELSIF lr_data_req.request_type IN ('SDR','SDB','SDH') THEN
  LOOP
    FETCH sdsdata INTO sdrec;
    EXIT WHEN sdsdata%NOTFOUND;
    UTL_FILE.PUT_LINE(my_out_file,sdrec);
  END LOOP;
END IF;

  CLOSE sdsdata;
  UTL_FILE.FCLOSE(my_out_file); 
  v_zip_rc := execmd('/bin/gzip -f '||DW_glob_var.lv_iodir||'/'||lr_data_req.filename);

  v_time_start := to_number(TO_CHAR(SYSDATE,'HH24')+TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
  LOOP
     utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,lr_data_req.filename||'.gz',v_exists,v_file_length,v_blocksize);
     v_time_current := to_number(TO_CHAR(SYSDATE,'HH24')+TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
    EXIT WHEN v_file_length > 0 OR ABS(v_time_start-v_time_current)> 0.01667;
  END LOOP; 
	
  v_time_start := to_number(TO_CHAR(SYSDATE,'HH24')+TO_CHAR(SYSDATE,'MI')/60+TO_CHAR(SYSDATE,'SS')/3600);
  LOOP
    v_time_current := to_number(TO_CHAR(SYSDATE,'HH24')+TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
    EXIT WHEN ABS(v_time_start-v_time_current)> 0.004;
  END LOOP;

-- check the file size 
  utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,lr_data_req.filename||'.gz',v_exists,v_file_length,v_blocksize);
    IF v_exists THEN
      lv_filesize_kb:=ROUND(v_file_length/1024,1);
      dbms_output.put_line(lr_data_req.email_address);

    update dw_data_requests
    set request_status='Completed',
        filesize_kb = lv_filesize_kb,
        processed_date =sysdate
    where request_id = p_req_id;
    commit;
select decode(lr_data_req.request_type,'SDS','Station Description','SDR','Regular Result','SDB','Biological Result','SDH','Habitat Result',lr_data_req.request_type) into lv_request_type from dual;

-- Email body
lv_email_body:= 'Your request for STORET '||lv_request_type||' download is completed via '||lr_data_req.request_mode||' batch processing.  The Request_ID is '||p_req_id||'.  You can download your file using the hyperlink '||dw_glob_var.lv_download_path||lr_data_req.filename||'.'||dw_glob_var.gv_cmprs_fl_ext;

-- send an email.
    dw_mail_pkg.send
    ( p_sender_email => dw_glob_var.gv_storet_email,
       p_from => 'STORET Web Site <'||dw_glob_var.gv_storet_email||'>',
       p_to => dw_mail_pkg.array( lr_data_req.email_address),
       p_subject => 'STORET data request status (COMPLETED).  Request_ID: '||p_req_id,
       p_body => lv_email_body);

--update dw_data_requests table.
  update dw_data_requests
  set notified = 'Y',
      processed_date=sysdate
  where request_id = p_req_id;
  commit;

   END IF;
commit;

exception when others then
  update dw_data_requests
  set request_status = 'Failed',
      processed_date=sysdate
  where request_id = p_req_id;
  commit;
end;
/
show errors;